#ifndef ODECYLINDER_H_
#define ODECYLINDER_H_

#include "IPhysicalCylinder.h"

#include <ode/ode.h>
namespace PhysicsEngine
{

class ODECylinder : public PhysicsEngine::IPhysicalCylinder
{
public:
	ODECylinder();
	ODECylinder(dWorldID world, int objectid, float radius, float length, Vector3f position,Vector3f rotation, int materialid, float mass, Vector3f linearvelocity, Vector3f angularvelocity);
	virtual ~ODECylinder();
	void UpdateData();
	dGeomID GetGeomId();
	DataCylinder *GetDataCylinder();
	dWorldID GetWorldId();
	void SetWorldId(dWorldID world);
	void RotateObject(float axis_x, float axis_y, float axis_z, float angle);
	void SetPhysicalPosition(float posx, float posy, float posz);
	Vector3f GetAngularVelocity();
	Vector3f GetLinearVelocity();
private:
	dGeomID bodyid;
	dWorldID world;	
};

}

#endif /*ODECYLINDER_H_*/
